//Playing Window
#include"disco2.h"
SimpleWindow Play_Window("DX BALL RELOADED", 26, 14.2);
//Play Area 
RectangleShape Play_Area(Play_Window, 13.0, 7.0, Black, 26, 14);
#define X_Play_Area_Left 0.3
#define X_Play_Area_Right 25.7
#define Y_Play_Area_Top 0.3
#define Y_Play_Area_Bottom 13.8
//Labels
//Label Level (Play_Window, Position(1,15.0), "Level : ", Black, White);

void DisplayAll()
{
	//Boundaries
	Play_Window.RenderLine(Position(0.0,0.0), Position(0,14.0), Green, 0.2);
	Play_Window.RenderLine(Position(0.0,0.0), Position(26,0), Green, 0.2);
	Play_Window.RenderLine(Position(0.0,14.1), Position(26,14.1), Green, 0.2);
	Play_Window.RenderLine(Position(26.0,0.0), Position(26,14.0), Green, 0.2);
	//Level.Draw();
};

/***********Paddle Info*************************/
#define ypaddle 13.7
#define length_paddle 3.0
#define width_paddle 0.4
float xpaddle = 13.0 , paddle_dir = 0.0, max_paddle_speed = 2.4, paddle_speed = 2.4;
RectangleShape Paddle(Play_Window, xpaddle, ypaddle, Red, length_paddle, width_paddle);
RectangleShape Paddle_Patch(Play_Window, 10.0, ypaddle, Black, length_paddle, width_paddle);
/**********************************************/
/**************Paddle Functions****************/
#define paddle_step 0.1
void movepaddle()
{
	Paddle_Patch.SetPosition(Position(xpaddle, ypaddle));
	Paddle_Patch.Draw();
	xpaddle = xpaddle + paddle_dir*paddle_step*paddle_speed;
	Paddle.SetPosition(Position( xpaddle, ypaddle ));
	Paddle.Draw();
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
/***************BALL INFO***********************/
float 	X_ball = 13.2;	//X cordinate of ball
float 	Y_ball = 13.3;	//Y cordinate of ball
float 	dia = 0.4000;		//ball diameter

CircleShape Ball(Play_Window,Position(X_ball,Y_ball),Green, dia);
CircleShape Ball_Patch(Play_Window,Position(X_ball,Y_ball),Black, dia);

float 	Xdir = 1.0;
float 	Ydir = -1.0;
float 	Xspeed = 0.6;
float 	Yspeed = 0.6;
float 	bricklength = 2;	//bricklength=brickimage.GetWidth();
float 	brickwidth = 1;		//brickwidth=brickimage.GetHight();

void yreflect();
void xreflect();
void moveball();
void delay(long int n);
void ifboundary();
void ifbrick();
int iffall();
float mod(float a);

/*..................................................................................*/
float mod(float a)  // to find modulus of a float
{
if(a>0)
	return a;
else
	return -a;
}

/*...................................................................................*/
void yreflect()			// To reflect on y_axis or a line parallel to y_axis
{
	Xdir=Xdir*(-1);
}

void xreflect()			//To reflect on x_axis or a line parallel to x_axis
{
	Ydir=Ydir*(-1);
}
/*.................................................................................*/
void moveball()		// just move the ball one step forward
{
	Ball_Patch.SetPosition(Position(X_ball,Y_ball));
	Ball_Patch.Draw();
	
	X_ball = X_ball + Xspeed*Xdir*(0.1);
	Y_ball = Y_ball + Yspeed*Ydir*(0.1);
	Ball.SetPosition(Position(X_ball,Y_ball));
	Ball.Draw();
} 
/*...................................................................................*/
void delay(long int n)		// Wait for sometime as decided by integer n
{
	long int i;
	for( i=0;i<n;i++);
}
/*...............................................................................*/
void ifboundary()	// checks whether the ball hits any boundary and reflects accordingly
{
        if(X_ball<=X_Play_Area_Left + dia/2 || X_ball >= X_Play_Area_Right - dia/2)
        {
        	yreflect();
        }
        if(Y_ball <= Y_Play_Area_Top + dia/2) 
        {
        	xreflect();
        }
	if((X_ball>=xpaddle - length_paddle/2 - dia/2)  && 
	(X_ball<=xpaddle + length_paddle/2 + dia/2) && 
	(Y_ball>=ypaddle - width_paddle/2 - dia/2)  &&
	(Y_ball<=ypaddle + width_paddle/2 + dia/2))
		{
			if((X_ball>=xpaddle - length_paddle/2)  &&  (X_ball <= xpaddle + length_paddle/2))
			{
				xreflect();  
			}
			else if((Y_ball>=ypaddle- width_paddle/2)  &&  (Y_ball<=ypaddle + width_paddle/2))
			{ 
				yreflect();  
			}
			else 
			{
				Xdir=(-1)*(xpaddle-X_ball)/(mod(xpaddle-X_ball));
				Ydir=(-1)*(ypaddle-Y_ball)/(mod(ypaddle-Y_ball));
     			}
		}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////
/***************************************BRICK LOGIC*****************************************************/
#define MAXCOLS 8
#define MAXROWS 6
#define xdiff 3.0
#define ydiff 1.2
#define bricklength 2.0
#define brickwidth 1.0

//Bricks
int LevelScore = 0;
int Score_Step_Up = 10;
int Number_Bricks = 48; 
float Position_Brick[48][2];
int Presence_Brick[48];

/**************************GENERATION OF DIFFERENT LEVELS***********************************/
void Build(int level)
{
	int status(0);
	switch (level)
	{
	case 1:
		Number_Bricks = 18;
		Score_Step_Up = 10;		
		for(int i=0;i < 4;i++)
		{
			Position_Brick[status][0]= 3.0 + i*xdiff;
			Position_Brick[status][1]= 1.5 + i*ydiff;
			Presence_Brick[status] = 1;
			RectangleShape brick(Play_Window, 3.0+i*xdiff , 1.5+i*ydiff , Blue , bricklength, brickwidth);
			brick.Draw();
			status++;
		}
		for(int j=0 ;j < 4;j++)
		{
			Position_Brick[status][0]= 3.0 + (3+j)*xdiff;
			Position_Brick[status][1]= 1.5 + (3-j)*ydiff;
			Presence_Brick[status] = 1;
			RectangleShape brick(Play_Window, 3.0 + (3 + j)*xdiff , 1.5 + (3 - j)*ydiff , Blue , bricklength, brickwidth);
			brick.Draw();
			status++;
		}
		for(int k=1;k < 4;k++)
		{
			Position_Brick[status][0]= 3.0 + k*xdiff;
			Position_Brick[status][1]= 1.5 + (k-1)*ydiff;
			Presence_Brick[status] = 1;
			RectangleShape brick(Play_Window, 3.0+k*xdiff , 1.5 + (k-1)*ydiff , Green , bricklength, brickwidth);
			brick.Draw();
			status++;
		}
		for(int l=1 ;l < 4;l++)
		{
			Position_Brick[status][0]= 3.0 + (2+l)*xdiff;
			Position_Brick[status][1]= 1.5 + (3-l)*ydiff;
			Presence_Brick[status] = 1;
			RectangleShape brick(Play_Window, 3.0 + (2 + l)*xdiff , 1.5 + (3 - l)*ydiff , Green , bricklength, brickwidth);
			brick.Draw();
			status++;
		}
		for(int m=2;m < 4;m++)
		{
			Position_Brick[status][0]= 3.0 + m*xdiff;
			Position_Brick[status][1]= 1.5 + (m-2)*ydiff;
			Presence_Brick[status] = 1;
			RectangleShape brick(Play_Window, 3.0+m*xdiff , 1.5 + (m-2)*ydiff , Yellow , bricklength, brickwidth);
			brick.Draw();
			status++;
		}
		for(int n=2 ;n < 4;n++)
		{
			Position_Brick[status][0]= 3.0 + (1+n)*xdiff;
			Position_Brick[status][1]= 1.5 + (3-n)*ydiff;
			Presence_Brick[status] = 1;
			RectangleShape brick(Play_Window, 3.0 + (1 + n)*xdiff , 1.5 + (3 - n)*ydiff , Yellow , bricklength, brickwidth);
			brick.Draw();
			status++;
		}
		for (int s = 18; s < 48; s++)	Presence_Brick[s] = 0;
		//Maybe change the speeds of the ball along the axes
		break;
	case 2:
	Number_Bricks = 48;
	Score_Step_Up = 15;
	for(int i=0;i < 6;i++)
	{
		for(int j=0;j < 8; j++)
		{
			RectangleShape brick(Play_Window, 2.2+j*xdiff , 1.5+i*ydiff , Blue , bricklength, brickwidth);
			brick.Draw();
			Position_Brick[status][0]= 2.2 + j*xdiff;
			Position_Brick[status][1]= 1.5 + i*ydiff;
			Presence_Brick[status]=1;
			status++;
		}
	}
	break;
	case 3:
	Number_Bricks = 28 ;
	Score_Step_Up = 20;
	for(int i = 0; i < 8; i++)
	{
		for(int j = 0; j < 7; j++)
		{
			Position_Brick[status][0]= 4.0 + j*xdiff;
			Position_Brick[status][1]= 1.5 + i*ydiff;
			if ((i + j) % 2 == 0)
			{
				RectangleShape brick(Play_Window, 4.0+j*xdiff , 1.5+i*ydiff , Yellow , bricklength, brickwidth);
				brick.Draw();
				Presence_Brick[status]=1;
				status++;
			}
			else Presence_Brick [status] = 0;
		}
	
	}
	for(int t = 42; t < 48; t++)
	{
		Presence_Brick[t] = 1;
	}
	Xspeed = 1.2;
	Yspeed = 0.8;
	break;
	
	case 4:
	Number_Bricks = 18;
	Score_Step_Up = 30;
	for(int i = 0; i < 8; i++)
	{
		for(int j = 0; j < 7; j++)
		{
			Position_Brick[status][0]= 4.0 + j*xdiff;
			Position_Brick[status][1]= 1.5 + i*ydiff;
			if ((i + j) % 5 == 0)
			{
				RectangleShape brick(Play_Window, 4.0+j*xdiff , 1.5+i*ydiff , Yellow , bricklength, brickwidth);
				brick.Draw();
				Presence_Brick[status]=1;
				status++;
			}
			else if ((i + j) % 7 == 0)
			{
				RectangleShape brick(Play_Window, 4.0+j*xdiff , 1.5+i*ydiff , Blue , bricklength, brickwidth);
				brick.Draw();
				Presence_Brick[status]=1;
				status++;
			}
			else Presence_Brick [status] = 0;
		}
	
	}
	for(int t = 42; t < 48; t++)
	{
		Presence_Brick[t] = 1;
	}
	Xspeed = 1.2;
	Yspeed = 1.0;
	max_paddle_speed = 3.0;
	break;
	case 5:
	Number_Bricks = 26;
	Score_Step_Up = 50;
	for(int i = 0; i < 8; i++)
	{
		for(int j = 0; j < 7; j++)
		{
			Position_Brick[status][0]= 4.0 + j*xdiff;
			Position_Brick[status][1]= 1.5 + i*ydiff;
			if ((i + j) % 3 == 0)
			{
				RectangleShape brick(Play_Window, 4.0+j*xdiff , 1.5+i*ydiff , Yellow , bricklength, brickwidth);
				brick.Draw();
				Presence_Brick[status]=1;
				status++;
			}
			else if ((i + j) % 7 == 0)
			{
				RectangleShape brick(Play_Window, 4.0+j*xdiff , 1.5+i*ydiff , Blue , bricklength, brickwidth);
				brick.Draw();
				Presence_Brick[status]=1;
				status++;
			}
			else Presence_Brick [status] = 0;
		}
	
	}
	for(int t = 42; t < 48; t++)
	{
		Presence_Brick[t] = 1;
	}
	Xspeed = 1.2;
	Yspeed = 0.8;
	max_paddle_speed = 3.0;
	break;
	}
}
/*********************************BRICK FUNCTIONS******************************************************/
void ifbrick()
{
	for(int j=0;j < 48;j++)
	{
		if(Presence_Brick[j] == 1)
		{
			if((X_ball>=Position_Brick[j][0] - bricklength/2 - dia/2)  && 
   			(X_ball<=Position_Brick[j][0] + bricklength/2 + dia/2) && 
   			(Y_ball>=Position_Brick[j][1] - brickwidth/2 - dia/2)  &&
   			(Y_ball<=Position_Brick[j][1] + brickwidth/2 + dia/2))
			{
				if((X_ball>=Position_Brick[j][0] - bricklength/2)  &&  (X_ball <= Position_Brick[j][0] + bricklength/2))
				{
					xreflect();  
					Presence_Brick[j]=0;
					Number_Bricks--;
					LevelScore = LevelScore + Score_Step_Up;
				}
				else if((Y_ball>=Position_Brick[j][1]- brickwidth/2)  &&  (Y_ball<=Position_Brick[j][1] + brickwidth/2))
				{ 
					yreflect();  
					Presence_Brick[j]=0;
					Number_Bricks--;
					LevelScore = LevelScore + Score_Step_Up;
				}
				else 
				{
					Xdir=(-1)*(Position_Brick[j][0]-X_ball)/(mod(Position_Brick[j][0]-X_ball));
					Ydir=(-1)*(Position_Brick[j][1]-Y_ball)/(mod(Position_Brick[j][1]-Y_ball));
               				Presence_Brick[j]=0;
					Number_Bricks--;
					LevelScore = LevelScore + Score_Step_Up;
	     			}
				RectangleShape destroybrick(Play_Window,Position_Brick[j][0],Position_Brick[j][1],Black,bricklength,brickwidth);
				destroybrick.Draw();
			}
		}
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/************************************************MENUS*******************************************************************************************/
SimpleWindow MainMenu("Main Menu",26,16);   //mainmenu window
SimpleWindow PauseMenu("Pause Menu",26,16);   //game pause window
SimpleWindow OptionMenu("Options",26,16);       //options window
SimpleWindow QuitMenu("Quit Menu",18,13);    //quit window
SimpleWindow GameStartPic("Gamestart",26,16);

int MainMenuClickEvent(const Position &);
int OptionMenuClickEvent(const Position &);
int QuitMenuClickEvent(const Position &);
int PauseMenuClickEvent(const Position &);
int GlobalParameter = 0;

BitMap Mainmenuwindow(MainMenu);
BitMap Playgame_tab(MainMenu);
BitMap Options_tab(MainMenu);
BitMap Quit_tab(MainMenu);
BitMap Gamepausemenuwindow(PauseMenu);
BitMap Resume_tab(PauseMenu);
BitMap Restart_tab(PauseMenu);
BitMap Backtomainmenu_tab(PauseMenu);
BitMap Quitmenuwindow(QuitMenu);
BitMap Quit_yes_tab(QuitMenu);
BitMap Quit_no_tab(QuitMenu);
BitMap Optionsmenuwindow(OptionMenu);
BitMap Instructions_tab(OptionMenu);
BitMap Credits_tab(OptionMenu);
BitMap Backto_Mainmenu_tab(OptionMenu);
BitMap Initialwindow(GameStartPic);

float position_tab=0;
void optionmenu();
void mainmenu();
void quitmenu();
void gamestart();

void PicturesLoad(void)
{
Mainmenuwindow.Load("Pictures/mainmenu.xpm");
Playgame_tab.Load("Pictures/playgame.xpm");
Options_tab.Load("Pictures/options.xpm");
Quit_tab.Load("Pictures/quit.xpm");
}

int MainMenuClickEvent(const Position &p)
{

	if(Playgame_tab.IsInside(p))
        {
		
		
		char ch; //character
	int factor = 0;
	int level = 1;
	char carriage_return;
	cout<<"ARE YOU READDYYYY!"<<endl;
	cout<<"Please enter a level:"<<endl<<"1 2 3 4 5"<<endl;
	cout<<"Press Ctrl C at any time to quit!"<<endl;
	cin>>level;
	if(level != 5 && level != 4 && level != 3 && level != 2 && level != 1)
	{
		cout<<endl<<"No such level exists."<<endl;
		return 1;
	}
	nonblock(0);
	Play_Window.Open();
	//Play_Window.Message("Please select the terminal!");
	Play_Area.Draw();
	DisplayAll();
	
	//lvl decided by the level selected at the level menu
	Ball.Draw();
	Paddle.Draw();
	nonblock(1);
	Build(level);
	cout<<"Press w and Enter to shoot ball"<<endl;
	cin>>carriage_return;
	nonblock(0);

	ch=fgetc(stdin);
	while(factor == 0 && Y_ball <= 14.0 - dia/2 && Number_Bricks > 0)
	{
	usleep(1);
	factor = keystroke();
	if (factor!=0)
	{
            	usleep(200);
            	ch=getchar();//=fgetc(stdin);
            	if (ch == 'q')	factor = 1;
             	else if(ch=='a'||ch=='A')
             	{
             		paddle_dir = - 1 ; 
             		factor = 0 ; 
             		paddle_speed = max_paddle_speed ; 
            		if (xpaddle <= (X_Play_Area_Left + length_paddle/2))	paddle_dir = 1 ;
             	}
            	else if(ch=='d'||ch=='D')
            	{
            		paddle_dir = 1 ; 
            		factor = 0 ; 
            		paddle_speed = 2.4 ; 
            		if (xpaddle >= (X_Play_Area_Right - length_paddle/2))	paddle_dir = -1;
            	}
               	else 
		{ 
			factor = 0 ; 
			paddle_speed = max_paddle_speed ; 
		}
        }
        movepaddle();
        moveball();
	ifbrick();
	ifboundary();
	usleep(18000);
	paddle_speed = 0;
	}
	cout<<endl<<"Your Score is:"<<LevelScore<<endl;
	if (Number_Bricks == 0)
	{
		paddle_speed = 0;
		Xspeed = 0;
		Yspeed = 0;
		cout<<endl<<"YOU WON!"<<endl;
		usleep(20000);
	}
	if (Y_ball >= 14.0 - dia/2) //Ball Falls Down
	{
		paddle_speed = 0;
		Xspeed = 0;
		Yspeed = 0;
		cout<<endl<<"GAME OVER!"<<endl;
		usleep(20000);
	}
	//reset
	factor = 0;
	nonblock(1);
	//reset ball info and paddle info
	LevelScore = 0;
	Ball_Patch.SetPosition(Position(X_ball,Y_ball));
	Paddle_Patch.SetPosition(Position(xpaddle, ypaddle));
	Ball_Patch.Draw();
	Paddle_Patch.Draw();
	X_ball = 13.2;	//X cordinate of ball
	Y_ball = 13.3;	//Y cordinate of ball
	xpaddle = 13.0;
	Xdir = 1;
	Ydir = -1;
	Xspeed = 0.6;
	Yspeed = 0.6;
	Play_Window.Close();

		
	}   cout<<"out";
	if(Options_tab.IsInside(p))	
	{
	       cout<<"opytiom";
	 	OptionMenu.Open();
		Optionsmenuwindow.Load("Pictures/optionmenu.xpm");
		Optionsmenuwindow.SetPosition(Position(5.5,2));
		Optionsmenuwindow.Draw();
		Instructions_tab.Load("Pictures/instructions.xpm");	
		Instructions_tab.SetPosition(Position(6.5,5));
		Instructions_tab.Draw();
		Credits_tab.Load("Pictures/credits.xpm");
		Credits_tab.SetPosition(Position(10.75,7));
		Credits_tab.Draw();
		Backtomainmenu_tab.Load("Pictures/mainmenutab.xpm");
		Backto_Mainmenu_tab.SetPosition(Position(15,9));
		Backto_Mainmenu_tab.Draw();
		OptionMenu.SetMouseClickCallback(OptionMenuClickEvent); 
	}
	if(Quit_tab.IsInside(p))	
	{
	        cout<<"quit";
	 	QuitMenu.Open();
		Quitmenuwindow.Load("Pictures/quitwindow.xpm");
		Quitmenuwindow.SetPosition(Position(3.5,4));
		Quitmenuwindow.Draw();
		Quit_yes_tab.Load("Pictures/yes.xpm");	
		Quit_yes_tab.SetPosition(Position(6.6,5.7));
		Quit_yes_tab.Draw();
		Quit_no_tab.Load("Pictures/no.xpm");
		Quit_no_tab.SetPosition(Position(6.6,7.5));
		Quit_no_tab.Draw();
		QuitMenu.SetMouseClickCallback(QuitMenuClickEvent); 
	}
	return 0;	
}

int OptionMenuClickEvent(const Position &v)
{
	if(Instructions_tab.IsInside(v))
	{
	 	//	instructions();
		cout<<"instructions";
	}
	if(Credits_tab.IsInside(v))
	{
		//	credits();
		cout<<"credits";
	}
	if(Backto_Mainmenu_tab.IsInside(v))
	{
		//	mainmenu();
        }
}

int QuitMenuClickEvent(const Position &y)
{
	if(Quit_yes_tab.IsInside(y))
	{
		//	exit();
		cout<<"exit";
	}
	if(Quit_no_tab.IsInside(y))
	{
	//	mainmenu();
		cout<<"no";
        }
}
